﻿//////////////////////////////////////////////
// SsaoEffect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;
}

namespace nkGraphics
{
	class Camera ;
	class Program ;
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

#include "../Effect.h"

#include "SsaoEffectInfo.h"

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT SsaoEffect final : public Effect
	{
		public :

			// Constructor, destructor
			SsaoEffect (System* system) noexcept ;
			virtual ~SsaoEffect () ;

			// Getters
			nkGraphics::Texture* getPositionBuffer () const ;
			nkGraphics::Texture* getNormalBuffer () const ;
			nkGraphics::Texture* getDepthBuffer () const ;
			bool getLinearDepth () const ;
			nkGraphics::Camera* getCamera () const ;
			float getSamplingRadius () const ;
			float getMaxOcclusionDistance () const ;
			float getStrength () const ;
			float getDepthBias () const ;
			unsigned int getKernelSampleCount () const ;
			bool getOcclusionDrivesAlpha () const ;

			// Setters
			void setEffectFromGBufferInfo (nkGraphics::Texture* positionBuffer, nkGraphics::Texture* normalBuffer = nullptr) ;
			void setEffectFromDepthInfo (nkGraphics::Texture* depthBuffer, bool linearDepth = false) ;
			void setCamera (nkGraphics::Camera* value) ;
			void setSamplingRadius (float value) ;
			void setMaxOcclusionDistance (float value) ;
			void setStrength (float value) ;
			void setDepthBias (float value) ;
			void setKernelSampleCount (unsigned int value) ;
			void setOcclusionDrivesAlpha (bool value) ;

			// Load
			virtual bool load () override ;
			virtual void unload () override ;

		public :

			// Statics
			static nkMemory::UniquePtr<SsaoEffect> create (System* system = nullptr) ;

		private :

			// Functions
			// Program
			bool _prepareProgram () ;

			// Shader
			bool _prepareShader () ;

		private :

			// Attributes
			System* _system ;

			// Program
			nkGraphics::Program* _program ;
			SsaoEffectInfo _programInfo ;

			// Info
			SsaoEffectInfo _info ;
	} ;
}